using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace _3zad
{
    internal class Program
    {
        public static void QuickSort(int[] niz, int p, int q)
        {
            if (p < q)
            {
                int pivotIndeks = Podeli(niz, p, q);
                QuickSort(niz, p, pivotIndeks - 1);
                QuickSort(niz, pivotIndeks + 1, q);
            }
        }

        private static int Podeli(int[] niz, int p, int q)
        {
            int pivot = niz[q];
            int i = p - 1;

            for (int j = p; j < q; j++)
            {
                if (niz[j] <= pivot)
                {
                    i++;
                    Zameni(niz, i, j);
                }
            }

            Zameni(niz, i + 1, q);
            return i + 1;
        }

        private static void Zameni(int[] niz, int a, int b)
        {
            int t = niz[a];
            niz[a] = niz[b];
            niz[b] = t;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            int[] x = new int[n];
            int[] h = new int[n];
            double a;
            string[] s = Console.ReadLine().Split(' ');
            for (int i = 0; i < n; i++)
            {
                x[i] = int.Parse(s[i]);
            }
            s = Console.ReadLine().Split();
            for (int i = 0; i < n; i++)
            {
                h[i] = int.Parse(s[i]);
            }
            QuickSort(x, 0, n - 1);
            double dmin = -1;
            for (int i = 0; i < n; i++)
            {
                dmin = -1;
                for (int j = 0; j < n; j++)
                {
                    if (i == j) continue;
                    if (h[i] <= h[j])
                    {
                        double d = Math.Abs(x[i] - x[j]);
                        if (d < dmin || dmin < 0) dmin = d;
                    }
                }
                for (int j = 0; j < n - 1; j++)
                {
                    double x1 = x[j]; double y1 = h[j];
                    double x2 = x[j + 1]; double y2 = h[j + 1];
                    double xp = (x1 +x2 + y1 - y2) / 2.0;
                    double yp = y1 - (xp - x1);
                    if (h[i] >= Math.Max(y1, y2) || h[i] < yp) continue;
                    if (y1 < y2)
                    {
                            if (h[i] >= y1 || x[i] >= x2)
                            {
                                Double X = (xp - yp) + h[i];
                                if (X >= xp && X <= x2)
                                {
                                    double d = Math.Abs(X - x[i]);
                                    if (dmin < 0 || d < dmin) dmin = d;
                                }
                            }
                            else 
                            {
                                 Double X = (xp + yp) - h[i];
                                 if (x1 <= X && X <= xp)
                                 {
                                     double d = Math.Abs(X - x[i]);
                                     if (dmin < 0 || d < dmin) dmin = d;
                                 }
                            }
                    }
                    else
                    {
                        if (h[i] >= y2 || x[i] <= x1)
                        {
                            Double X = (xp + yp) - h[i];
                            if (x1 <= X && X <= xp)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                        else
                        {
                            Double X = (xp - yp) + h[i];
                            if (X >= xp && X <= x2)
                            {
                                double d = Math.Abs(X - x[i]);
                                if (dmin < 0 || d < dmin) dmin = d;
                            }
                        }
                    }
                }
                if (dmin < 0) Console.WriteLine(-1);
                else Console.WriteLine(dmin);
            }
            Console.ReadLine();
        }
    }
}